// ColorKeyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ColorKey.h"
#include "ColorKeyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

struct _colorkeystuff
{
	BYTE Alpha;
	BYTE Red;
	BYTE Green;
	BYTE Blue;
	BYTE Threshold;
	BYTE Spill_Suppress_Threshold;

	_colorkeystuff() :
	Alpha	 ( 0xFF ),
	Red		 ( 0x00 ),
	Green	 ( 0xFF ),
	Blue	 ( 0x00 ),
	Threshold( 0x19 ),
	Spill_Suppress_Threshold( 0x10 ){}

} clrkey;

CColorKeyDlg *CColorKeyDlg::s_pColorKeyDlg = 0;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CColorKeyDlg *pColorKeyDlg = (CColorKeyDlg *)(pUserData);

	pColorKeyDlg->m_nVideoWidth = 0;
	
	pColorKeyDlg->m_nVideoHeight = 0;
	
	pColorKeyDlg->m_bVideoIsInterleaved = FALSE;
	
	pColorKeyDlg->m_dVideoFrameRate = 0.0;
	
	pColorKeyDlg->m_nAudioChannels = 0; 
	
	pColorKeyDlg->m_nAudioBitsPerSample = 0;
	
	pColorKeyDlg->m_nAudioSampleFrequency = 0;

	pColorKeyDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CColorKeyDlg *pColorKeyDlg = (CColorKeyDlg *)(pUserData);

	pColorKeyDlg->m_nVideoWidth = 0;
	
	pColorKeyDlg->m_nVideoHeight = 0;
	
	pColorKeyDlg->m_bVideoIsInterleaved = FALSE;
	
	pColorKeyDlg->m_dVideoFrameRate = 0.0;
	
	pColorKeyDlg->m_nAudioChannels = 0; 
	
	pColorKeyDlg->m_nAudioBitsPerSample = 0;
	
	pColorKeyDlg->m_nAudioSampleFrequency = 0;

	pColorKeyDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CColorKeyDlg *pColorKeyDlg = (CColorKeyDlg *)(pUserData);

	pColorKeyDlg->m_nVideoWidth = nVideoWidth;
	
	pColorKeyDlg->m_nVideoHeight = nVideoHeight;
	
	pColorKeyDlg->m_bVideoIsInterleaved = bVideoIsInterleaved;
	
	pColorKeyDlg->m_dVideoFrameRate = dVideoFrameRate;
	
	pColorKeyDlg->m_nAudioChannels = nAudioChannels; 
	
	pColorKeyDlg->m_nAudioBitsPerSample = nAudioBitsPerSample;
	
	pColorKeyDlg->m_nAudioSampleFrequency = nAudioSampleFrequency;

	pColorKeyDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CColorKeyDlg *pColorKeyDlg = (CColorKeyDlg *)(pUserData);

    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CColorKeyDlg *pColorKeyDlg = (CColorKeyDlg *)(pUserData);

    return QCAP_RT_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CColorKeyDlg dialog

CColorKeyDlg::CColorKeyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CColorKeyDlg::IDD, pParent)
	, m_static_spill_suppress_threshold(_T(""))
{
	//{{AFX_DATA_INIT(CColorKeyDlg)
	m_static_alpha = _T("");
	m_static_b = _T("");
	m_static_g = _T("");
	m_static_r = _T("");
	m_static_threshold = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CColorKeyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorKeyDlg)
	DDX_Control(pDX, IDC_SLIDER_THRESHOLD, m_scroll_threshold);
	DDX_Control(pDX, IDC_SLIDER_R, m_scroll_r);
	DDX_Control(pDX, IDC_SLIDER_G, m_scroll_g);
	DDX_Control(pDX, IDC_SLIDER_B, m_scroll_b);
	DDX_Control(pDX, IDC_SLIDER_ALPHA, m_scroll_alpha);
	DDX_Text(pDX, IDC_STATIC_ALPHA, m_static_alpha);
	DDX_Text(pDX, IDC_STATIC_B, m_static_b);
	DDX_Text(pDX, IDC_STATIC_G, m_static_g);
	DDX_Text(pDX, IDC_STATIC_R, m_static_r);
	DDX_Text(pDX, IDC_STATIC_THRESHOLD, m_static_threshold);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_SPILL_SUPPRESS_THRESHOLD, m_spill_suppress_threshold);
	DDX_Text(pDX, IDC_STATIC_SPILL_SUPPRESS_THRESHOLD, m_static_spill_suppress_threshold);
}

BEGIN_MESSAGE_MAP(CColorKeyDlg, CDialog)
	//{{AFX_MSG_MAP(CColorKeyDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON, OnButton)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_ALPHA, OnReleasedcaptureSliderAlpha)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_B, OnReleasedcaptureSliderB)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_G, OnReleasedcaptureSliderG)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_R, OnReleasedcaptureSliderR)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_THRESHOLD, OnReleasedcaptureSliderThreshold)
	//}}AFX_MSG_MAP
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SPILL_SUPPRESS_THRESHOLD, &CColorKeyDlg::OnNMReleasedcaptureSpillSuppressThreshold)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorKeyDlg message handlers

BOOL CColorKeyDlg::ReadBmp( LPCSTR pszFileName, BYTE *&po, INT &nHeight , INT &nWidth, unsigned short &bit_per_pixel, unsigned short &byte_per_pixel )
{
	
	if( po ) { free( po ); po = NULL; }

	//
	// READ AN IMAGE
	//
	HANDLE hFile = ::CreateFile(	pszFileName, 
									GENERIC_READ, 
									FILE_SHARE_READ, 
									NULL, 
									OPEN_EXISTING, 
									FILE_ATTRIBUTE_NORMAL,
									NULL );

        if(hFile == INVALID_HANDLE_VALUE)
	{
		MessageBox( "Error!!" );

        return FALSE;
	}

	HANDLE hMap = ::CreateFileMapping( hFile, NULL, PAGE_READONLY, NULL, NULL, NULL );
	
	LPVOID lpBase = ::MapViewOfFile(hMap, FILE_MAP_READ, 0, 0, 0);

	BITMAPFILEHEADER *pFileHeader;	// bitmap file-header

	BITMAPINFO *pInfoHeader;		// bitmap info-header

	pFileHeader = (BITMAPFILEHEADER*)lpBase;
	
	if( pFileHeader->bfType != MAKEWORD('B', 'M') )
	{
		MessageBox( "IT'S NOT BMP" );

		::UnmapViewOfFile( lpBase );

		::CloseHandle( hMap );

		::CloseHandle( hFile );

		return FALSE;
	}

	BYTE *pBits = (BYTE*)lpBase + pFileHeader->bfOffBits;

	pInfoHeader = (BITMAPINFO*)((BYTE*)lpBase + sizeof(BITMAPFILEHEADER));

	bit_per_pixel = pInfoHeader->bmiHeader.biBitCount;			// bit per pixel

	byte_per_pixel = bit_per_pixel / 8;							// byte per pixel

	if( bit_per_pixel != 24 ) { AfxMessageBox( "Only Support BMP.24 Format!" ); return FALSE; }
	
	nHeight = pInfoHeader->bmiHeader.biHeight;
	
	nWidth = pInfoHeader->bmiHeader.biWidth;

	po = (BYTE *)malloc( nWidth * nHeight * byte_per_pixel );

	for( INT i = (nHeight-1); i >= 0; i-- )
	{
		for( INT j = 0; j < nWidth * byte_per_pixel; j+=byte_per_pixel )
		{
			ULONG tar_y = ((nHeight-1) - i);

			ULONG src_y = i;

			po[ tar_y*(nWidth*byte_per_pixel) + j + 0 ] = pBits[ src_y*(nWidth*byte_per_pixel) + j + 0 ];

			po[ tar_y*(nWidth*byte_per_pixel) + j + 1 ] = pBits[ src_y*(nWidth*byte_per_pixel) + j + 1 ];

			po[ tar_y*(nWidth*byte_per_pixel) + j + 2 ] = pBits[ src_y*(nWidth*byte_per_pixel) + j + 2 ];
		}
	}

	::UnmapViewOfFile( lpBase );

	::CloseHandle( hMap );

	::CloseHandle( hFile );

	return TRUE;
}


BOOL CColorKeyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	CColorKeyDlg::s_pColorKeyDlg = this;

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	m_hVideoDevice = NULL;

	m_nVideoWidth = 0;
	
	m_nVideoHeight = 0;
	
	m_dVideoFrameRate = 0.0;

	m_bVideoIsInterleaved = 0;
	
	m_nAudioChannels = 0; 
	
	m_nAudioBitsPerSample = 0;
	
	m_nAudioSampleFrequency = 0;

	m_po = 0;

	m_n_img_height = 0;
	
	m_n_img_width = 0;

	m_n_bit_per_pixel = 0;

	m_n_byte_per_pixel = 0;
	//
	// INITIALIZE SCROLL 
	//
	{
		m_scroll_alpha.SetRange( 0, 255, TRUE );
		m_scroll_b.SetRange( 0, 255, TRUE );
		m_scroll_g.SetRange( 0, 255, TRUE );
		m_scroll_r.SetRange( 0, 255, TRUE );
		m_scroll_threshold.SetRange( 0, 127, TRUE );
		m_spill_suppress_threshold.SetRange( 0, 255, TRUE );

		m_scroll_alpha.SetPos( clrkey.Alpha );
		m_scroll_b.SetPos( clrkey.Blue );
		m_scroll_g.SetPos( clrkey.Green );
		m_scroll_r.SetPos( clrkey.Red );
		m_scroll_threshold.SetPos( clrkey.Threshold );
		m_spill_suppress_threshold.SetPos( clrkey.Spill_Suppress_Threshold );

		m_static_alpha.Format( "%i", clrkey.Alpha );
		m_static_b.Format( "%i", clrkey.Blue );
		m_static_g.Format( "%i", clrkey.Green );
		m_static_r.Format( "%i", clrkey.Red );
		m_static_threshold.Format( "%i", clrkey.Threshold );
		m_static_spill_suppress_threshold.Format( "%i", clrkey.Spill_Suppress_Threshold );

		UpdateData(FALSE);	
	}	

	// INITIALIZE DEVICE RESOURCE
	//
	QCAP_CREATE( "QP0203 PCI", 0, GetDlgItem( IDC_STATIC_DISPLAY )->m_hWnd, &m_hVideoDevice, TRUE );

	//QCAP_CREATE( "CAMERA", 0, GetDlgItem( IDC_STATIC_DISPLAY )->m_hWnd, &m_hVideoDevice, TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice, on_no_signal_removed_callback, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice, on_audio_preview_callback, this );

	QCAP_SET_VIDEO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	QCAP_SET_AUDIO_VOLUME( m_hVideoDevice, 0 );

	QCAP_RUN( m_hVideoDevice );

	//
	//	DEFAULT AN IMAGE PATH
	//
	{	CHAR sz[ MAX_PATH ];

		memset( (PVOID)sz, 0, sizeof(CHAR)*MAX_PATH );

		LPSTR psz = sz;

		::GetModuleFileName( 0, psz, sizeof(CHAR) * MAX_PATH );

		psz[ strlen(psz) - 12 ] = '\0';

		sprintf( psz, "%sColorKey.BMP", psz );

		m_strDefaultPath = psz;

		sprintf( psz, "Image Path : %s", m_strDefaultPath );

		GetDlgItem( IDC_STATIC_PATH )->SetWindowText( psz );
	}
	//
	// MAPPING AN IMAGE TO MEMORY
	//
	BOOL fRet = ReadBmp( "ColorKey.BMP", m_po, m_n_img_height, m_n_img_width, m_n_bit_per_pixel, m_n_byte_per_pixel );

	if( !fRet ) { return FALSE; }

	clrkey.Blue = m_scroll_b.GetPos();

	clrkey.Red = m_scroll_r.GetPos();

	clrkey.Green = m_scroll_g.GetPos();

	ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

	QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, 0xFF, colorkey /* KEYCOLOR */, 25 /*0 ~ 128*/ );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CColorKeyDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CColorKeyDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CColorKeyDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CColorKeyDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CColorKeyDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	if( m_hVideoDevice ) {

		QCAP_STOP( m_hVideoDevice );

		QCAP_DESTROY( m_hVideoDevice );

		m_hVideoDevice = NULL;
	}

	if( m_po ) { free( m_po ); }

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();	
}

void CColorKeyDlg::OnButton() 
{
	// TODO: Add your control notification handler code here

	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "BMP\0*.BMP\0;";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_strDefaultPath = psz;

		CHAR psz[ 512 ];

		sprintf( psz, "Image Path : %s", m_strDefaultPath );

		GetDlgItem( IDC_STATIC_PATH )->SetWindowText( psz );

		BOOL fRet = ReadBmp( m_strDefaultPath, m_po, m_n_img_height, m_n_img_width, m_n_bit_per_pixel, m_n_byte_per_pixel );

		if( !fRet ) { return; }

		clrkey.Blue = m_scroll_b.GetPos();

		clrkey.Red = m_scroll_r.GetPos();

		clrkey.Green = m_scroll_g.GetPos();

		ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

		QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, 0xFF, colorkey /* KEYCOLOR */, 25 /*0 ~ 128*/ );
	}
	else {

		return;
	}	
}

void CColorKeyDlg::OnReleasedcaptureSliderAlpha(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	//
	// SET SCROLL 
	//
	if( !m_hVideoDevice ) { return; }

	clrkey.Alpha = m_scroll_alpha.GetPos();

	m_static_alpha.Format( "%i", clrkey.Alpha );

	ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

	BYTE threshold = clrkey.Threshold;

	BYTE Spill_Suppress_threshold = clrkey.Spill_Suppress_Threshold;

	QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, clrkey.Alpha, colorkey /* KEYCOLOR */, threshold /*0 ~ 128*/, 2, 1, Spill_Suppress_threshold );

	UpdateData( FALSE );		
	
	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderB(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	//
	// SET SCROLL 
	//
	if( !m_hVideoDevice ) { return; }

	clrkey.Blue = m_scroll_b.GetPos();

	m_static_b.Format( "%i", clrkey.Blue );

	ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

	BYTE threshold = clrkey.Threshold;

	BYTE Spill_Suppress_threshold = clrkey.Spill_Suppress_Threshold;

	QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, clrkey.Alpha, colorkey /* KEYCOLOR */, threshold /*0 ~ 128*/, 2, 1, Spill_Suppress_threshold );

	UpdateData( FALSE );		

	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderG(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	//
	// SET SCROLL 
	//
	if( !m_hVideoDevice ) { return; }

	clrkey.Green = m_scroll_g.GetPos();

	m_static_g.Format( "%i", clrkey.Green );

	ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

	BYTE threshold = clrkey.Threshold;

	BYTE Spill_Suppress_threshold = clrkey.Spill_Suppress_Threshold;

	QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, clrkey.Alpha, colorkey /* KEYCOLOR */, threshold /*0 ~ 128*/, 2, 1, Spill_Suppress_threshold );

	UpdateData( FALSE );		
	
	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderR(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	//
	// SET SCROLL 
	//
	if( !m_hVideoDevice ) { return; }

	clrkey.Red = m_scroll_r.GetPos();

	m_static_r.Format( "%i", clrkey.Red );

	ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

	BYTE threshold = clrkey.Threshold;

	BYTE Spill_Suppress_threshold = clrkey.Spill_Suppress_Threshold;

	QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, clrkey.Alpha, colorkey /* KEYCOLOR */, threshold /*0 ~ 128*/, 2, 1, Spill_Suppress_threshold );

	UpdateData( FALSE );	

	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderThreshold(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	//
	// SET SCROLL 
	//
	if( !m_hVideoDevice ) { return; }

	clrkey.Threshold = m_scroll_threshold.GetPos();

	m_static_threshold.Format( "%i", clrkey.Threshold );

	ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

	BYTE threshold = clrkey.Threshold;

	BYTE Spill_Suppress_threshold = clrkey.Spill_Suppress_Threshold;

	QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, clrkey.Alpha, colorkey /* KEYCOLOR */, threshold /*0 ~ 128*/, 2, 1, Spill_Suppress_threshold );

	UpdateData( FALSE );	

	*pResult = 0;
}


void CColorKeyDlg::OnNMReleasedcaptureSpillSuppressThreshold(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	if( !m_hVideoDevice ) { return; }

	clrkey.Spill_Suppress_Threshold = m_spill_suppress_threshold.GetPos();

	m_static_spill_suppress_threshold.Format( "%i", clrkey.Spill_Suppress_Threshold );

	ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

	BYTE threshold = clrkey.Threshold;

	BYTE Spill_Suppress_threshold = clrkey.Spill_Suppress_Threshold;

	QCAP_SET_OSD_BUFFER( m_hVideoDevice, 0, 0, 0, 0, 0, QCAP_COLORSPACE_TYEP_BGR24, m_po, m_n_img_width, m_n_img_height, m_n_img_width*m_n_byte_per_pixel, clrkey.Alpha, colorkey /* KEYCOLOR */, threshold /*0 ~ 128*/, 2, 1, Spill_Suppress_threshold );

	UpdateData( FALSE );	

	*pResult = 0;
}




void CColorKeyDlg::OnTimer(UINT nIDEvent) 
{
	if( nIDEvent == 0x000000000 ) {

		KillTimer( 0x00000000 );

		if( m_nVideoWidth == 0 ||

			m_nVideoHeight == 0 ) {

			GetDlgItem( IDC_STATIC_FORMAT )->SetWindowText( "INFO: ..." );
		}
		else {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "INFO: %d x %d%c @ %2.3f, %d x %d x %d", m_nVideoWidth, m_nVideoHeight, m_bVideoIsInterleaved ? 'i' : 'p', m_dVideoFrameRate, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency );

			GetDlgItem( IDC_STATIC_FORMAT )->SetWindowText( psz );
		}
	}

	CDialog::OnTimer(nIDEvent);
}

